@rem *** This batch file only makes solid RGB textures by use of the
@rem *** quantizeRGB() command. If you want another type of texture, you'll
@rem *** have to modify the batch file yourself, or make a new one.

@rem --- Set this to the name of the base palette
@set PALETTENAME=%1

@rem --- Set this to the desired palette key
@set PALETTEKEY=%2

@rem --- Some parameters for picaNew
@set RENDERSTART=1
@set RENDEREND=254

@echo off

rem --- Make sure the temporary files doesn't already exist
 del temp.pca

rem --- Write the parameters into the temporary file
 echo quantizeRGB() >> temp.pca
 echo outputPath(8bit) >> temp.pca
 echo basePalName(palettes\pal\%PALETTENAME%.pal) >> temp.pca
 echo paletteKey(%PALETTEKEY%) >> temp.pca
 echo renderRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo extrudeMipLevels() >> temp.pca
 echo enforcePhoenixSave() >> temp.pca
 echo bitmapListStart() >> temp.pca
 echo 24bit\%PALETTENAME%\*.bmp >> temp.pca

rem --- Begin conversion to Phoenix bitmap
 picanew -v4 @temp.pca

rem --- Cleanup
 del temp.pca